/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface PlayerSelector {
    public static PlayerSelector of(Object o) {
        if (o instanceof class_3222) {
            class_3222 sp = (class_3222)o;
            return PlayerSelector.identity(sp);
        }
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return PlayerSelector.uuid(uuid);
        }
        String name = Objects.toString(o, "").trim().toLowerCase();
        if (name.isEmpty()) {
            return PlayerSelector.identity(null);
        }
        UUID uuid = UUIDWrapper.fromString((Object)name);
        if (uuid != null) {
            return PlayerSelector.uuid(uuid);
        }
        return PlayerSelector.name(name).or(PlayerSelector.fuzzyName(name));
    }

    @Nullable
    public class_3222 getPlayer(MinecraftServer var1);

    public static PlayerSelector identity(class_3222 player) {
        return server -> player;
    }

    public static PlayerSelector uuid(UUID uuid) {
        return server -> server.method_3760().method_14602(uuid);
    }

    public static PlayerSelector name(String name) {
        return server -> server.method_3760().method_14566(name);
    }

    public static PlayerSelector fuzzyName(String name) {
        return server -> {
            for (class_3222 p : server.method_3760().method_14571()) {
                if (!p.method_5820().toLowerCase(Locale.ROOT).contains(name)) continue;
                return p;
            }
            return null;
        };
    }

    default public PlayerSelector or(PlayerSelector fallback) {
        return server -> {
            class_3222 p = this.getPlayer(server);
            return p == null ? fallback.getPlayer(server) : p;
        };
    }
}

